package gov.va.med.mhv.admin.web.formbean;

import gov.va.med.mhv.admin.dto.EmployeeDTO;
import gov.va.med.mhv.admin.dto.EmployeeOrgRoleHistoryDTO;
import gov.va.med.mhv.admin.dto.EmployeeSearchResult;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * This bean was created to hold everything about the employee currently under 
 * management. Only 1 can be loaded at a time. This class ensures that no
 * lingering parts of one employee can be associated with another employee.
 * 
 * @author DNS   HODGEJ
 *
 */
public class ManagedStaffMember implements Serializable {

	private static final long serialVersionUID = 3462746608602950512L;

	private EmployeeDTO managedEmployee = null;
	private Collection<EmployeeSearchResult> employeeSearchResultsList = null;
	private EmployeeSearchResult employeeToManage = null;
	private List<EmployeeOrgRoleHistoryDTO> roleHistoriesForEmployee;
	private String employeeLastLogin = "";

	public Collection<EmployeeSearchResult> getEmployeeSearchResultsList() {
		return employeeSearchResultsList;
	}

	public void setEmployeeSearchResultsList(
			Collection<EmployeeSearchResult> employeeSearchResultsList) {
		this.employeeSearchResultsList = employeeSearchResultsList;
	}

	public EmployeeSearchResult getEmployeeToManage() {
		return employeeToManage;
	}

	public void setEmployeeToManage(EmployeeSearchResult employeeToManage) {
		this.employeeToManage = employeeToManage;
	}

	public String getEmployeeLastLogin() {
		return employeeLastLogin;
	}

	public void setEmployeeLastLogin(String employeeLastLogin) {
		this.employeeLastLogin = employeeLastLogin;
	}

	public List<EmployeeOrgRoleHistoryDTO> getRoleHistoriesForEmployee() {
		return roleHistoriesForEmployee;
	}

	public void setRoleHistoriesForEmployee(
			List<EmployeeOrgRoleHistoryDTO> roleHistoriesForEmployee) {
		this.roleHistoriesForEmployee = roleHistoriesForEmployee;
	}

	public EmployeeDTO getManagedEmployee() {
		return managedEmployee;
	}

	public void setManagedEmployee(EmployeeDTO managedEmployee) {
		this.managedEmployee = managedEmployee;
	}

}
